<?php 
function showMessageError($context, $exception) {
    $errorMessage = sprintf(
        "%s: %s in %s on line %d\nStack trace:\n%s",
        $context,
        $exception->getMessage(),
        $exception->getFile(),
        $exception->getLine(),
        $exception->getTraceAsString()
    );

    // Mostrar en pantalla
    return nl2br($errorMessage); // Convierte saltos de línea a <br> para formato web

}
function writeLog($message, $logFile = 'app.log') {
    // Ruta completa al archivo de log
    $filePath = __DIR__ . '/' . $logFile;

    // Formato del mensaje con timestamp
    $logMessage = $message . PHP_EOL;

    // Escribir o agregar el mensaje al archivo
    try {
        file_put_contents($filePath, $logMessage, FILE_APPEND | LOCK_EX);
    } catch (Exception $e) {
        // Manejo de errores al escribir en el log
        error_log('No se pudo escribir en el archivo de log: ' . $e->getMessage());
    }
}

function executeSelfProcess($nros, $execute) {
    //list($limit, $timer) = calcularLimiteYTimer($nros); //Dependiendo la cantidad de tiempo, programa el tiempo de espra y la llamada asincrona al proceso. (si es false)
    
    //if ($execute) {
    //    sleep($timer);
    //    callApiAsync("https://stamping.io/crypto/lacchain.php?token=49487fhfyrkdh4657fndjd74dhdjd74747473&limit=$limit");
    //}
     return [$limit, $timer];
}
function calcularLimiteYTimer($nros) {
    if ($nros > 5120) {
        return [5120, 30];
    } elseif ($nros > 512) {
        return [512, 60];
    } else {
        $timer = 20; // Valor por defecto
        if ($nros < 20) {
            $timer = 500;
        } elseif ($nros < 1200) {
            $timer = 500;
        } elseif ($nros < 2000) {
            $timer = 500;
        } elseif ($nros < 5000) {
            $timer = 220;
        } elseif ($nros < 7000) {
            $timer = 120;
        }
        $timer=500;
        return [500, $timer];
    }
}

function showMessage($type, $msg) {
    echo($msg."</br>");
    $pidFilePath = 'pid.txt'; // Define la ruta donde se guardará el archivo PID
    // Leer el contenido del archivo
    $pid = file_get_contents($pidFilePath);
    writeLog($msg."</br>","log.html");
}
function showEsp($nro) {
    global $showType;
    showMessage($showType,"");
}
function showHeader($aFecha, $limit, $pid ="0") {
    global $showType;
    showMessage($showType,"*******************************************************************************");
    showMessage($showType,"<h2>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;STAMPING BLOCK GENERATOR              </h2>");
    showMessage($showType,"&nbsp;&nbsp;&nbsp;&nbsp;Trxid&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;: ".hash("sha1",hash("sha256",$aFecha)));
    showMessage($showType,"&nbsp;&nbsp;&nbsp;&nbsp;Fecha&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;: ".$aFecha);
    showMessage($showType,"&nbsp;&nbsp;&nbsp;&nbsp;Block Size: ".$limit);
    showMessage($showType,"&nbsp;&nbsp;&nbsp;&nbsp;PID: ".$pid);
    showEsp(1);
    showMessage($showType,"*******************************************************************************");
    showMessage($showType,"<h3>EXECUTED PROCESSES</h3>");
    
}

function showTitle($showType, $title) {
    showMessage($showType,"<b>     .: ".$title." </b>");
}
function showSubTitle($showType, $title) {
    showMessage($showType,"<b>&nbsp;&nbsp;&nbsp;<i>".$title."</i> </b>");
}
function setPID() {
    $pidFilePath = 'pid.txt'; // Define la ruta donde se guardará el archivo PID
    // Leer el contenido del archivo
    $pid = file_get_contents($pidFilePath);
    if (isProcessRunning($pid)) {
        //exit;
    }
    $pid = getmypid(); // Obtener el ID del proceso actual
    // Escribir el PID en un archivo
    file_put_contents($pidFilePath, $pid);
    return $pid;
}
function isProcessRunning($pid) {
    // Verifica si el PID es un número entero positivo
    if (is_numeric($pid) && $pid > 0) {
        // Usa posix_kill con señal 0 para verificar si el proceso está activo
        $result = posix_kill($pid, 0);
        return $result;
    }
    return false;
}

?>