<?php 
/*
Lee la cantidad de registros disponibles en el memory pool
*/
function getMinuteWaitForHashTimestamp() {
    $conn = connectDB();
    $sql="SELECT TIMESTAMPDIFF(MINUTE, MIN(timestamp), NOW()) AS minutes  FROM hashes_men ";
    $resultado=$conn->query($sql);
    $obj = $resultado->fetch_object();
    $resultado->free();
    return $obj->minutes;
}

/*
Lee la cantidad de registros disponibles en el memory pool
*/
function getCountHashes() {
    $conn = connectDB();
    $sql="SELECT COUNT(1) nro FROM hashes_men ";
    $resultado=$conn->query($sql);
    $obj = $resultado->fetch_object();
    $resultado->free();
    return $obj->nro;
}

/*
Crea el bloque3 nuevo tomando el ID menor de la TX y el maximo ID del TX
Lee los hashes que fueron tomados en el bloque
*/
function getHashes($hashesTMPCount, &$hashblock) {
    global $showType;
    $conn = connectDB(); // Asegúrate de definir la función connectDB()
    $aFecha = date_format(new DateTime(), 'Y-m-d H:i:s');  
    showTitle($showType,"getHashes()");
    showMessage($showType,"          Start : ".$aFecha);
        
    /*Se toma la menor y max id de mem_pool*/
    $block_from =   $conn->query("SELECT  IFNULL(min(id),0)  idx FROM hashes_tmp")->fetch_object()->idx;
    $block_to   =   $conn->query("SELECT  IFNULL(max(id),0)  idx FROM hashes_tmp")->fetch_object()->idx;
    
    $hashblock  =   calculateHash($aFecha.$block_from.$block_to);
    $sql        =   "INSERT INTO block3(hashes_tmp, hashblock, hashtree, idx_from, idx_to) VALUES ($hashesTMPCount,'".$hashblock."','',".$block_from.",".$block_to.") ";
    $resultado  =$conn->query($sql); 
    if (!$resultado) {
        echo '{"code":"401", "message":"'. $sql.'   '.$conn->error.'"}';
        list($limit, $timer) = executeSelfProcess(512, true); //Dependiendo la cantidad de tiempo, programa el tiempo de espra y la llamada asincrona al proceso. (si es false)
        exit;
    }
    
    //Lee los datos del archivo temporal
    $sql = "SELECT  hash FROM hashes_tmp ";
    $resultado=$conn->query($sql); 

    $aFecha = date_format(new DateTime(), 'Y-m-d H:i:s');
    showMessage($showType,"          End  : ".$aFecha);
    
    if (!$resultado) { 
        showMessage($showType,"          Count: -1");
        showMessage($showType,"          Error: ".$conn->error);
        list($limit, $timer) = executeSelfProcess(512, true); //Dependiendo la cantidad de tiempo, programa el tiempo de espra y la llamada asincrona al proceso. (si es false)
    
        exit;
    }
     else showMessage($showType,"          Count: ".$resultado->num_rows);    
    showEsp(1);
    //$conn->close();
    return $resultado;
}

/*
Regresa los hashes de mempool hacia hashes en caso de un error de proceso
*/
function insertarHashes() {
    $conn = connectDB(); // Asegúrate de que la función connectDB() esté definida y maneje las excepciones adecuadamente

    // Preparar la sentencia SQL
    $sql = "INSERT INTO hashes(lacchain, owner, xfrom, trxtId, transactionType, userid, IDX_USERID, hash, hash1, hash2, hash3, resume, data, timestamp_orig, flg, tsaFile, token, xlat, xlong, hashType, reference, url, ip, request_method, type, blockNumberLCH, errorLCH, intento, duration, bytes, blockactual, sc_tx, address, flgcarga, particion)
            SELECT lacchain, owner, xfrom, trxtId, transactionType, userid, IDX_USERID, hash, hash1, hash2, hash3, resume, data, timestamp, flg, tsaFile, token, xlat, xlong, hashType, reference, url, ip, request_method, type, blockNumberLCH, errorLCH, intento, duration, bytes, blockactual, sc_tx, address, flgcarga, particion
            FROM hashes_tmp " ;
    try {
        // Ejecutar la consulta
        if ($conn->query($sql) === false) {
            throw new Exception("Error al insertar datos: " . $conn->error);
        }
    } catch (Exception $e) {
        // Manejar la excepción, por ejemplo, registrando el error
        error_log($e->getMessage());
        // También puedes mostrar un mensaje al usuario o realizar otras acciones según sea necesario
    }
}






function insertarBlockNetwork($avaxid, $optxid, $rollopid, $bfaid, $hashblock, $maticid, $ftmid, $daiid, $celoid, $lacchainid, $ropstenid, $stampingid) {
    // Conectar a la base de datos
    $conn = connectDB();

    // Preparar la sentencia SQL
    $stmt = $conn->prepare("INSERT INTO block_networks (avaxid, optxid, rollopid, bfaid, hashblock, maticid, ftmid, daiid, celoid, lacchainid, ropstenid, stampingid) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    // Verificar si la preparación fue exitosa
    if ($stmt === false) {
        list($limit, $timer) = executeSelfProcess(512, true); //Dependiendo la cantidad de tiempo, programa el tiempo de espra y la llamada asincrona al proceso. (si es false)
        exit;
    }

    // Vincular los parámetros
    $stmt->bind_param("ssssssssssss", $avaxid, $optxid, $rollopid, $bfaid, $hashblock, $maticid, $ftmid, $daiid, $celoid, $lacchainid, $ropstenid, $stampingid);
    try {
    // Ejecutar la consulta
    if ($stmt->execute()) {
        return true;
    } else {
        echo "Error al insertar el registro: " . $stmt->error;
        list($limit, $timer) = executeSelfProcess(512, true); //Dependiendo la cantidad de tiempo, programa el tiempo de espra y la llamada asincrona al proceso. (si es false)
        exit;
    }
    } catch (DivisionByZeroError $e) {
        echo "Error al insertar el registro: " . $stmt->error;
        list($limit, $timer) = executeSelfProcess(512, true); //Dependiendo la cantidad de tiempo, programa el tiempo de espra y la llamada asincrona al proceso. (si es false)
        exit;
    }

    // Cerrar la declaración y la conexión
    $stmt->close();
    //$conn->close();
}



function deleteDB($conn) { 
    $sql = "delete from tree";    
    $resultado=$conn->query($sql); 
    if (!$resultado) {
        echo '{"code":"401", "message":"'. $sql.'   '.$conn->error.'"}';
        list($limit, $timer) = executeSelfProcess(512, true); //Dependiendo la cantidad de tiempo, programa el tiempo de espra y la llamada asincrona al proceso. (si es false)
    
        exit;
        
    }
}

function addDB($hash,$hashleft, $hashright, $hashtree, $hashblock) {
    $version="0.0.1";
    $hashtype="SHA256";
    
    $conn = connectDB();
    $sql = "INSERT INTO tree (hashblock, hash, hashtype, hashleft, hashright, version, hashtree) VALUES ('".$hashblock."','".$hash."','".$hashtype."','".$hashleft."','".$hashright."', '".$version."', '".$hashtree."')";
    $result = $conn->query($sql); 
    $conn->close();
}

function getHashTmpCount($limit) {
    global $showType;
    $conn = connectDB();
    $aFecha = date_format(new DateTime(), 'Y-m-d H:i:s');    
    showMessage($showType,"");
    showTitle($showType,"getHashTmpCount()");
    showMessage($showType,"          Start : ".$aFecha);
    $sql = "SELECT count(1) nro FROM `hashes_tmp` ";
    $resultado=$conn->query($sql);
    $obj = $resultado->fetch_object();

    if ($obj->nro>0) {
        
        //Inserta en hashes_errors todos los hashes que estaban en mem_pool y que no se cargaron en hashes
        $sql = "INSERT INTO `hashes_men`(id, `lacchain`, `owner`, `xfrom`, `trxtId`, `transactionType`, `userid`, `IDX_USERID`, `hash`, `hash1`, `hash2`, `hash3`, `resume`, `data`, `timestamp`, `flg`, `tsaFile`, `token`, `xlat`, `xlong`, `hashType`, `reference`, `url`, `ip`, `request_method`, `type`, `blockNumberLCH`, `errorLCH`, `intento`, `duration`, `bytes`, `blockactual`, `sc_tx`, `address`, `flgcarga`, `particion`)  SELECT  id, `lacchain`, `owner`, `xfrom`, `trxtId`, `transactionType`, `userid`, `IDX_USERID`, `hash`, `hash1`, `hash2`, `hash3`, `resume`, `data`, `timestamp`, `flg`, `tsaFile`, `token`, `xlat`, `xlong`, `hashType`, `reference`, `url`, `ip`, `request_method`, `type`, `blockNumberLCH`, `errorLCH`, `intento`, `duration`, `bytes`, `blockactual`, `sc_tx`, `address`, `flgcarga`, `particion` FROM `hashes_tmp` where id not in (select id from hashes_men)";
        $resultado=$conn->query($sql);
        $sql = "DELETE FROM `hashes_tmp` ";
        $resultado=$conn->query($sql);
        $sql = "INSERT INTO `hashes_tmp`(id,`lacchain`, `owner`, `xfrom`, `trxtId`, `transactionType`, `userid`, `IDX_USERID`, `hash`, `hash1`, `hash2`, `hash3`, `resume`, `data`, `timestamp`, `flg`, `tsaFile`, `token`, `xlat`, `xlong`, `hashType`, `reference`, `url`, `ip`, `request_method`, `type`, `blockNumberLCH`, `errorLCH`, `intento`, `duration`, `bytes`, `blockactual`, `sc_tx`, `address`, `flgcarga`, `particion`)  SELECT  id,`lacchain`, `owner`, `xfrom`, `trxtId`, `transactionType`, `userid`, `IDX_USERID`, `hash`, `hash1`, `hash2`, `hash3`, `resume`, `data`, `timestamp`, `flg`, `tsaFile`, `token`, `xlat`, `xlong`, `hashType`, `reference`, `url`, `ip`, `request_method`, `type`, `blockNumberLCH`, `errorLCH`, `intento`, `duration`, `bytes`, `blockactual`, `sc_tx`, `address`, `flgcarga`, `particion` FROM `hashes_men` LIMIT ".$limit;
        $resultado=$conn->query($sql);
        $aFecha = date_format(new DateTime(), 'Y-m-d H:i:s');
        showMessage($showType,"          End  : ".$aFecha);
        showMessage($showType,"          Count: ".$obj->nro);
        showMessage($showType,"          Limit ".$limit);
        showMessage($showType,"          Action: Logged in table hash_error and data is removed from hashes_tmp ");
        
    } else {
        
        /*Se toman los primeros 5000 filas del mem_pool*/
        $sql = "INSERT INTO `hashes_tmp`(id,`lacchain`, `owner`, `xfrom`, `trxtId`, `transactionType`, `userid`, `IDX_USERID`, `hash`, `hash1`, `hash2`, `hash3`, `resume`, `data`, `timestamp`, `flg`, `tsaFile`, `token`, `xlat`, `xlong`, `hashType`, `reference`, `url`, `ip`, `request_method`, `type`, `blockNumberLCH`, `errorLCH`, `intento`, `duration`, `bytes`, `blockactual`, `sc_tx`, `address`, `flgcarga`, `particion`)  SELECT  id,`lacchain`, `owner`, `xfrom`, `trxtId`, `transactionType`, `userid`, `IDX_USERID`, `hash`, `hash1`, `hash2`, `hash3`, `resume`, `data`, `timestamp`, `flg`, `tsaFile`, `token`, `xlat`, `xlong`, `hashType`, `reference`, `url`, `ip`, `request_method`, `type`, `blockNumberLCH`, `errorLCH`, `intento`, `duration`, `bytes`, `blockactual`, `sc_tx`, `address`, `flgcarga`, `particion` FROM `hashes_men` LIMIT ".$limit;
        echo("INSERT INTO `hashes_tmp` => $limit rows");
        $resultado=$conn->query($sql);
            
        
        $aFecha = date_format(new DateTime(), 'Y-m-d H:i:s');
        showMessage($showType,"          End  : ".$aFecha);
        showMessage($showType,"          Count: ".$obj->nro);
        showMessage($showType,"          Limit ".$limit);
    }
    //$conn->close();
    showEsp(1);
    return $obj->nro;
}

function stampCreateBlock($aFecha, $hashesTMPCount) {
    global $showType;
    $aFecha = date_format(new DateTime(), 'Y-m-d H:i:s');  
    showTitle($showType,"stampCreateBlock()");
    showMessage($showType,"          Start : ".$aFecha);
    
    /*Se crea una evidencia del tamaño del bloque*/
    $url ="https://api.stamping.io/stamp/?token=b078afeae53cda3d17d1ea1e6ea13&evidence=".hash("sha256",$aFecha)."&async=true&data=".base64_encode('{\"count_tmp\":'.$hashesTMPCount.', \"date\":\"'.$aFecha.'\"}')."&transactionType=CreateBlock";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_TIMEOUT, 0);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, FALSE);
    $response2 = curl_exec($ch);
    curl_close($ch);
    if (json_decode($response2)->code!=="200") {
        echo($response2);    
    } 
    $aFecha = date_format(new DateTime(), 'Y-m-d H:i:s'); 
    showMessage($showType,"          End  : ".$aFecha);
    showMessage($showType,"          Evidence: ".hash("sha256",$aFecha));
    showMessage($showType,"          hashesTMPCount: ".$hashesTMPCount);
    showEsp(1);
}

function getRecipientInBlock3() {
    $conn = connectDB();
    $sql="SELECT max(id) recipient FROM block3";
    $resultado22=$conn->query($sql);
    $obj = $resultado22->fetch_object();
    $recipient = $obj->recipient;
    $resultado22->free();
    //$conn->close();
    return $recipient;
}
function connectDB() {
    static $conn = null; // Mantiene la conexión entre llamadas a esta función
    try {
        if ($conn !== null) 
            $conn->close();
    } catch (Exception $e) {
    } 
        
        $users = array("stamping_bt");
        $userDB = $users[array_rand($users)];
        
        $conn = new mysqli("p:localhost", $userDB, "Joarzaso123*.", "stamping_tsa");
        $conn->set_charset("utf8mb4");
        $conn->autocommit(TRUE); 
        mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
        
        if ($conn->connect_error) {
            list($limit, $timer) = executeSelfProcess(20, true); //Dependiendo la cantidad de tiempo, programa el tiempo de espra y la llamada asincrona al proceso. (si es false)
            exit;
        }
    
    return $conn;
}

function saveMerkleTreeToIPFS($hash, $recipient, $hashblock, &$ipfsCID) {     
    global $showType;
    $conn = connectDB();
    showEsp(1); 
    showSubTitle($showType,"saveMerkleTreeToIPFS()");
    $aFecha = date_format(new DateTime(), 'Y-m-d H:i:s');
    showMessage($showType,"&nbsp;&nbsp;&nbsp;Start : ".$aFecha);
    $conn->set_charset("utf8mb4");
    $conn->query("SET SESSION group_concat_max_len = 10000000");
    showMessage($showType,"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.:&nbsp;GetDataFromHashTemp()&nbsp;:&nbsp;".$aFecha);

/*
$sql = "
SELECT 
    userid, 
    address, 
    COUNT(1) AS nums,
    CONCAT(
        '[', GROUP_CONCAT(
            CONCAT(
                '{\"id\":', @rownum := @rownum + 1, 
                ',\"hash\":\"', CONVERT(hash USING utf8mb4), 
                '\", \"trxtid\":\"', CONVERT(trxtid USING utf8mb4), 
                '\", \"hashsource\":\"', CONVERT(SHA2(CONCAT(ip, SHA1(token)), 256) USING utf8mb4), 
                '\"}'
            ) ORDER BY trxtid
        ), ']'
    ) AS attestations
FROM 
    (SELECT @rownum := 0) r, hashes_tmp
GROUP BY userid, address";

$sql="";
        
        $result = $conn->query($sql);
        showMessage($showType,"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.:&nbsp;ReturnData()&nbsp;:&nbsp;".$aFecha);
        
        $jsonTotal = '{"version":"1.0.1","block":{"recipient": "' . $recipient . '", "data":[';
        $coma = "";
        
        while ($obj = $result->fetch_object()) {
            $jsonTotal .= $coma . '{"id":' . ($i + 1) . ',"userid":"' . $obj->userid . '","address":"' . $obj->address . '","count":"' . $obj->nums . '","attestations":' . $obj->attestations . '}';
            $coma = ",";
            $i++;
        }
        
        $result->free();
        
        $jsonTotal .= ']}';
        
*/        

    /*
    $sql = "SELECT userid, address,count(1) nums FROM  hashes_tmp group by userid, address";
    $result = $conn->query($sql);

    $jsonTotal='{"block": "'.$recipient.'", "data":[';
    $coma="";
    $i=0;
    
    while ($obj = $result->fetch_object()) {
        $i++;
        if ($i==2) $coma=",";
        $jsonTotal=$jsonTotal.$coma.'{"id":'.$i.',"userid":"'.$obj->userid.'","address":"'.$obj->address.'","count":"'.$obj->nums.'", "attestations":[';
        $sql2 = "SELECT trxtid, hash, token, ip FROM  hashes_tmp where userid='".$obj->userid."'";
         $conn = connectDB();
        $result2 = $conn->query($sql2);
        $jsonHashes="[";
        $coma2=""; $j=0;
        while ($obj2 = $result2->fetch_object()) {
            $j++;
            if ($j==2) $coma2=",";
            $jsonTotal=$jsonTotal.$coma2.'{"id":'.$j.',"hash":"'.$obj2->hash.'", "trxtid":"'.$obj2->trxtid.'", "hashsource":"'.hash("sha256",$obj2->ip.hash("sha1",$obj2->token)).'"}';
        }
        $result2->free();
        $jsonTotal=$jsonTotal."]}";
    }
    $result->free();
    
    $jsonTotal=$jsonTotal."]";
    */
    
    

    $sql = "SELECT 
                userid, 
                address, 
                hash, 
                trxtid, 
                SHA2(CONCAT(ip, SHA1(token)), 256) AS hashsource 
            FROM hashes_tmp 
            ORDER BY userid, address, trxtid";
    
    $result = $conn->query($sql);
    
    showMessage($showType, "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.:&nbsp;ReturnData()&nbsp;:&nbsp;" . $aFecha);
    
    $jsonTotal = '{"version":"1.0.1","block":{"recipient": "' . $recipient . '", "data":[';
    $coma = "";
    $data = [];
    $i = 0;
    
    if ($result) {
        while ($obj = $result->fetch_object()) {
            $key = $obj->userid . "_" . $obj->address;
            
            if (!isset($data[$key])) {
                $data[$key] = [
                    "id" => $i + 1,
                    "userid" => $obj->userid,
                    "address" => $obj->address,
                    "count" => 0,
                    "attestations" => []
                ];
            }
    
            $data[$key]["count"]++;
            $data[$key]["attestations"][] = [
                "id" => $data[$key]["count"],
                "hash" => $obj->hash,
                "trxtid" => $obj->trxtid,
                "hashsource" => $obj->hashsource
            ];
        }
    }
    showMessage($showType, "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.:&nbsp;JSONWasGenerated()&nbsp;:&nbsp;" . $aFecha);
    
    foreach ($data as $item) {
        $jsonTotal .= $coma . json_encode($item, JSON_UNESCAPED_UNICODE);
        $coma = ",";
    }
    
    $jsonTotal .= ']}';
    
    showMessage($showType, "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.:&nbsp;JSONWasFormated()&nbsp;:&nbsp;" . $aFecha);
    
    $result->free();
    

    
    showMessage($showType, "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.:&nbsp;GetDataFromTree()&nbsp;:&nbsp;" . $aFecha);
    
    $sql = "SELECT hash, hashleft, hashright, hashtree FROM  tree where hashblock='$hashblock'";
    $result = $conn->query($sql);
    $json=$jsonTotal.',"merkletree":[';
    $coma=""; 
    $i=0;
    
    showMessage($showType, "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.:&nbsp;ReturnData()&nbsp;:&nbsp;" . $aFecha);
    
    while ($obj = $result->fetch_object()) {
        $i++;
        if ($i==2) $coma=",";
        $json=$json.$coma.'{"id":'.$i.',"hash":"'.$obj->hash.'","tree":{"l":"'.$obj->hashleft.'", "r":"'.$obj->hashright.'", "t":"'.$obj->hashtree.'"}}';
    }
    
    showMessage($showType, "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.:&nbsp;JSONWasGenerated()&nbsp;:&nbsp;" . $aFecha);
    $result->free();
    //$conn->close();
    
    $json=$json."]}";
    $base64="data:application/json;base64,".base64_encode($json);    
    
    
    showMessage($showType, "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SendAPI(Pinata)&nbsp;:&nbsp;" . $aFecha);
            
    $ch = curl_init();
    curl_setopt_array($ch, array(
              CURLOPT_URL => "https://api.stamping.io/ipfs/file/?",
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'POST',
              CURLOPT_POSTFIELDS =>'{"token":"6c4bfe8bbeda70ca347d955b10979b8857f4e693b660fb75c0ac870cfd5","name":"0x'.$hash.'","description":"Stamping.io: Merkle Tree Block: 0x'.$hashblock.'","file":"'.$base64.'"}',
              CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
              ),
            ));
     
    $response = curl_exec($ch);
    showMessage($showType, "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Return(Pinata)&nbsp;:&nbsp;" . $aFecha);
    showMessage($showType, "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$response&nbsp;:&nbsp;" );
    curl_close($ch);
    $respuesta = json_decode($response);
    $ipfsCID = $respuesta->cid;
    if (!$ipfsCID || $ipfsCID=="") {
        echo("IPFS Not Found  hash: $hash : Input: ".'{"token":"*******************","name":"0x'.$hash.'","description":"Stamping.io: Merkle Tree Block: 0x'.$hashblock.'","file":"'.$base64.'"}'."-> Resp: ".json_encode($respuesta));
        mysqli_close($conn);
        list($limit, $timer) = executeSelfProcess(512, true); //Dependiendo la cantidad de tiempo, programa el tiempo de espra y la llamada asincrona al proceso. (si es false)
    
        exit;
    }
    
    
    $conn = connectDB();        
    $cid =  hash("sha256",$ipfsCID);          
    $sql ="INSERT INTO ipfsblock(cid, hashblock, hashtree) VALUES ('$ipfsCID','$hashblock','".$hash."')";
    $result = $conn->query($sql);
    //$conn->close();
    
    $aFecha = date_format(new DateTime(), 'Y-m-d H:i:s');
    showMessage($showType,"&nbsp;&nbsp;&nbsp;End : ".$aFecha);
    showMessage($showType,"&nbsp;&nbsp;&nbsp;CID : ".$ipfsCID);
    showMessage($showType,"&nbsp;&nbsp;&nbsp;Hash: ".$hash);
    showMessage($showType,"&nbsp;&nbsp;&nbsp;HashBlock: ".$hashblock);
    
    return $cid;
}

?>